<?php
// 短信一对一发送接口

$userName = ''; // 帐号用户名
$password = ''; // 帐号密码
$timestamp = time() * 1000; // 获取当前时间戳，精确到毫秒
$messageList = [ // 短信内容和发送手机号码列表
    [
        'phone' => '15011111111',
        'content' => '【签名】短信内容1'
    ],
    [
        'phone' => '15022222222',
        'content' => '【签名】短信内容2'
    ]
];

// 计算 sign 参数值
$sign = md5($userName . $timestamp . md5($password));

// 定义请求数据
$data = [
    'userName' => $userName,
    'messageList' => $messageList,
    'timestamp' => $timestamp,
    'sign' => $sign
];

// 定义请求选项
$options = [
    'http' => [
        'header'  => "Content-Type: application/json;charset=utf-8\r\nAccept: application/json\r\n",
        'method'  => 'POST',
        'content' => json_encode($data)
    ]
];

// 发送 HTTP 请求
$context  = stream_context_create($options);
$result = file_get_contents('http://{address:port}/sms/api/sendMessageOne', false, $context);

// 输出响应数据
echo $result;
